'\" t
.TH groff_ms @MAN7EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
groff_ms \- GNU
.I roff
manuscript macro package for formatting documents
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright (C) 1989-2025 Free Software Foundation, Inc.
.\"
.\" Permission is granted to make and distribute verbatim copies of this
.\" manual provided the copyright notice and this permission notice are
.\" preserved on all copies.
.\"
.\" Permission is granted to copy and distribute modified versions of
.\" this manual under the conditions for verbatim copying, provided that
.\" the entire resulting derived work is distributed under the terms of
.\" a permission notice identical to this one.
.\"
.\" Permission is granted to copy and distribute translations of this
.\" manual into another language, under the above conditions for
.\" modified versions, except that this permission notice may be
.\" included in translations approved by the Free Software Foundation
.\" instead of in the original English.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_groff_ms_7_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.nr do-fallback 0
.if !\n(.f           .nr do-fallback 1 \" mandoc
.if  \n(.g .if !d MR .nr do-fallback 1 \" older groff
.if !\n(.g           .nr do-fallback 1 \" non-groff *roff
.if \n[do-fallback]  \{\
.  de MR
.    ie \\n(.$=1 \
.      I \%\\$1
.    el \
.      IR \%\\$1 (\\$2)\\$3
.  .
.\}
.rr do-fallback
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY "groff \-m@TMAC_S_PREFIX@s"
.RI [ option\~ .\|.\|.\&]
.RI [ file\~ .\|.\|.]
.YS
.
.SY "groff \-m m@TMAC_S_PREFIX@s"
.RI [ option\~ .\|.\|.\&]
.RI [ file\~ .\|.\|.]
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
The GNU implementation of the
.I ms
macro package is part of the
.I groff
document formatting system.
.
The
.I ms
package is suitable for the composition of
letters,
memoranda,
reports,
and books.
.
.
.LP
These
.I groff
macros support cover page and table of contents generation,
automatically numbered headings,
several paragraph styles,
a variety of text styling options,
footnotes,
and multi-column page layouts.
.
.I ms
supports the
.MR @g@tbl @MAN1EXT@ ,
.MR @g@eqn @MAN1EXT@ ,
.MR @g@pic @MAN1EXT@ ,
and
.MR @g@refer @MAN1EXT@
preprocessors for inclusion of tables,
mathematical equations,
diagrams,
and consistently formatted bibliographic citations.
.
.
.P
.I "groff ms"
is mostly compatible with the documented interface
and behavior of AT&T Unix Version\~7
.IR ms .
.
It recreates most extensions from 4.2BSD (Berkeley)
.\" Few changes were made in 4.3, Reno, Tahoe, or 4.4.
and Research Tenth Edition Unix.
.
.
.\" ====================================================================
.SH "Document structure"
.\" ====================================================================
.
The
.I ms
macro package expects a certain amount of structure:
a well-formed document contains at least one paragraphing or heading
macro call.
.
.\" This sentence is unique to the man page because we omit the "Basic
.\" information" section from ms.ms.
To compose a simple document from scratch,
begin it by calling
.B LP
or
.BR PP .
.
Organize longer documents as follows.
.
.
.TP
.B Document type
Calling the
.B RP
macro at the beginning of your document puts the document description
(see below)
on a cover page.
.
Otherwise,
.I ms
places this information
on the first page,
followed immediately by the body text.
.
Some document types found in other
.I ms
implementations are specific to AT&T or Berkeley,
and are not supported in
.IR "groff ms" .
.
.
.TP
.B "Format and layout"
By setting registers and strings,
you can configure your document's typeface,
margins,
spacing,
headers and footers,
and footnote arrangement.
.
See subsection \[lq]Document control settings\[rq] below.
.
.
.TP
.B Document description
A document description consists of any of:
a title,
one or more authors' names and affiliated institutions,
an abstract,
and a date or other identifier.
.
See subsection \[lq]Document description macros\[rq] below.
.
.
.TP
.B Body text
The main matter of your document follows its description
(if any).
.
.I ms
supports highly structured text consisting of paragraphs interspersed
with multi-level headings
(chapters,
sections,
subsections,
and so forth)
and augmented by lists,
footnotes,
tables,
diagrams,
and similar material.
.
The preponderance of subsections below covers these matters.
.
.
.TP
.B "Table of contents"
Macros enable the collection of entries for a table of contents
(or index)
as the material they discuss appears in the document.
.
A macro call at the end of the document emits the collected entries.
.
This material necessarily follows the rest of the text since GNU
.I troff \" GNU
is a single-pass formatter;
it cannot determine the page number of a division of the text
until it has been set and output.
.
Since
.I ms
output was designed for the production of hard copy,
the traditional procedure was to manually relocate the pages containing
the table of contents between the cover page and the body text.
.
Today,
page resequencing is more often done in the digital domain.
.
An index works similarly,
but because it typically needs to be sorted after collection,
its preparation requires separate processing.
.
.
.\" ====================================================================
.SS "Document control settings"
.\" ====================================================================
.
The following tables list the document control registers,
strings,
and special characters.
.
For any parameter whose default is unsatisfactory,
define it before calling any
.I ms
macro other than
.BR RP .
.
.
.LP
.ne 7v
.TS
cb    s  s  s
cb   cb cb cb
lf(CR) lx  l  lf(CR).
Margin settings
Parameter	Definition	Effective	Default
_
\[rs]n[PO]	Page offset (left margin)	next page	1i (0)
\[rs]n[LL]	Line length	next paragraph	6.5i (65n)
\[rs]n[LT]	Title line length	next paragraph	6.5i (65n)
\[rs]n[HM]	Top (header) margin	next page	1i
\[rs]n[FM]	Bottom (footer) margin	next page	1i
_
.TE
.
.
.LP
.ne 8v
.TS
cb    s  s  s
cb   cb cb cb
lf(CR) lx  l  lf(CR).
Titles (headers, footers)
Parameter	Definition	Effective	Default
_
\[rs]*[LH]	Left header text	next header	\f[I]empty
\[rs]*[CH]	Center header text	next header	\-\[rs]n[%]\-
\[rs]*[RH]	Right header text	next header	\f[I]empty
\[rs]*[LF]	Left footer text	next footer	\f[I]empty
\[rs]*[CF]	Center footer text	next footer	\f[I]empty
\[rs]*[RF]	Right footer text	next footer	\f[I]empty
_
.TE
.
.
.LP
.ne 6v
.TS
cb   s  s  s
cb   cb cb cb
lf(CR) lx l  lf(CR).
Text settings
Parameter	Definition	Effective	Default
_
\[rs]n[PS]	Point (type) size	next paragraph	10p
\[rs]n[VS]	Vertical spacing (leading)	next paragraph	12p
\[rs]n[HY]	Hyphenation mode	next paragraph	6
\[rs]*[FAM]	Font family	next paragraph	T
_
.TE
.
.
.LP
.ne 6v
.TS
cb   s  s  s
cb   cb cb cb
lf(CR)2 lx l  lf(CR).
Paragraph settings
Parameter	Definition	Effective	Default
_
\[rs]n[PI]	Indentation	next paragraph	5n
\[rs]n[PD]	Paragraph distance (spacing)	next paragraph	0.3v\
 \f[R](\f[]1v\f[R])
\[rs]n[QI]	Quotation indentation	next paragraph	5n
\[rs]n[PORPHANS]	# of initial lines kept	next paragraph	1
_
.TE
.
.
.ne 10v \" Keep table and subsequent paragraph together.
.LP
.TS
cb   s  s  s
cb   cb cb cb
lf(CR) lx l  lf(CR).
Heading settings
Parameter	Definition	Effective	Default
_
\[rs]n[PSINCR]	Point (type) size increment	next heading	1p
\[rs]n[GROWPS]	Size increase depth limit	next heading	0
\[rs]n[HORPHANS]	# of following lines kept	next heading	1
\[rs]*[SN\-STYLE]	Numbering style (alias)	next heading	\[rs]*[SN\-DOT]
_
.TE
.
.
.LP
.B \[rs]*[SN\-STYLE]
can alternatively be made an alias of
.B \[rs]*[SN\-NO\-DOT]
with the
.B als
request.
.
.
.LP
.ne 8v
.TS
cb   s  s  s
cb   cb cb cb
lf(CR) lx  l  lf(CR).
Footnote settings
Parameter	Definition	Effective	Default
_
\[rs]n[FI]	Indentation	next footnote	2n
\[rs]n[FF]	Format	next footnote	0
\[rs]n[FPS]	Point (type) size	next footnote	\[rs]n[PS]\-2p
\[rs]n[FVS]	Vertical spacing (leading)	next footnote	\[rs]n[FPS]+2p
\[rs]n[FPD]	Paragraph distance (spacing)	next footnote	\[rs]n[PD]/2
\[rs]*[FR]	Line length ratio	\f[I]special	11/12
_
.TE
.
.
.LP
.ne 4v
.TS
cb   s  s  s
cb   cb cb cb
lf(CR) lx  l  lf(CR).
Display settings
Parameter	Definition	Effective	Default
_
\[rs]n[DD]	Display distance (spacing)	\f[I]special	0.5v\
 \f[R](\f[]1v\f[R])
\[rs]n[DI]	Display indentation	\f[I]special	0.5i
_
.TE
.
.
.LP
.ne 3v
.TS
cb   s  s  s
cb   cb cb cb
lf(CR) lx  l  lf(CR).
Other settings
Parameter	Definition	Effective	Default
_
\[rs]n[MINGW]	Minimum gutter width	next page	2n
\[rs]n[TC\-MARGIN]	TOC page number margin width	\
next \f[B]PX\f[] call	\[rs]w\[aq]000\[aq]
\[rs][TC\-LEADER]	TOC leader character	next \f[B]PX\f[] call\
	.\[rs]h\[aq]1m\[aq]
_
.TE
.
.
.LP
For entries marked
.RI \[lq] special \[rq]
in the \[lq]Effective\[rq] column,
see the discussion in the applicable section below.
.
The
.BR PO ,
.BR LL ,
and
.B LT
register defaults vary by output device and paper format;
the values shown are for typesetters using U.S.\& letter paper,
and then terminals.
.
See section \[lq]Paper format\[rq] of
.MR groff @MAN1EXT@ .
.
The
.B PD
and
.B DD
registers use the larger value if the vertical motion quantum of the
output device is too coarse for the smaller one;
usually,
this is the case only for output to terminals.
.
The \[lq]gutter\[rq] affected by
.B \[rs]n[MINGW]
is the gap between columns in multiple-column page arrangements.
.
The
.B TC\-MARGIN
register and
.B TC\-LEADER
special character affect the formatting of tables of contents assembled
by the
.BR XS ,
.BR XA ,
and
.B XE
macros.
.
.
.\" ====================================================================
.SS "Document description macros"
.\" ====================================================================
.
Define information describing the document by calling the macros below
in the order shown;
.B DA
or
.B ND
can be called to set the document date
(or other identifier)
at any time before (a) the abstract,
if present,
or (b) its information is required in a header or footer.
.
Use of these macros is optional,
except that
.B TL
is mandatory if any of
.BR RP ,
.BR AU ,
.BR AI ,
or
.B AB
is called,
and
.B AE
is mandatory if
.B AB
is called.
.
.
.TP
.BR .RP\~ [ no\-repeat\-info ]\~[ no\-renumber ]
Use the \[lq]report\[rq]
(AT&T: \[lq]released paper\[rq])
format for your document,
creating a separate cover page.
.
The default arrangement is to place most of the document description
(title,
author names and institutions,
and abstract,
but not the date)
at the top of the first page.
.
If the optional
.B no\-\:\%repeat\-\:\%info
argument is given,
.I ms
produces a cover page but does not repeat any of its information
subsequently
(but see the
.B DA
macro below regarding the date).
.
Normally,
.B RP
sets the page number following the cover page to\~1.
.
Specifying the optional
.B no\-\:\%renumber
argument suppresses this alteration.
.
Optional arguments can occur in any order.
.
.I ms
recognizes
.B no
as a synonym of
.B no\-\:\%repeat\-\:\%info
to maintain AT&T compatibility.
.
Options other than
.B no
are GNU extensions.
.
.
.TP
.B .TL
Specify the document title.
.
.I ms
collects text on input lines following this call into the title until
reaching
.BR AU ,
.BR AB ,
or a heading or paragraphing macro call.
.
.
.TP
.B .AU
Specify an author's name.
.
.I ms
collects text on input lines following this call into the author's name
until reaching
.BR AI ,
.BR AB ,
another
.BR AU ,
or a heading or paragraphing macro call.
.
Call it repeatedly to specify multiple authors.
.
.
.TP
.B .AI
Specify the preceding author's institutional affiliation.
.
An
.B AU
call is usefully followed by at most one
.B AI
call;
if there are more,
the last
.B AI
call controls.
.
.I ms
collects text on input lines following this call into the author's
institution until reaching
.BR AU ,
.BR AB ,
or a heading or paragraphing macro call.
.
.
.TP
.BR .DA \~[\c
.IR x \~.\|.\|.]
Typeset the current date,
or any
.RI arguments\~ x ,
in the center footer,
and,
if
.B RP
is also called,
left-aligned at the end of the document description on the cover page.
.
.
.TP
.BR .ND \~[\c
.IR x \~.\|.\|.]
Typeset the current date,
or any
.RI arguments\~ x ,
if
.B RP
is also called,
left-aligned at the end of the document description on the cover page.
.
This is
.IR "groff ms" 's
default.
.
.
.TP
.BR ".AB " [ no ]
Begin the abstract.
.
.I ms
collects text on input lines following this call into the abstract until
reaching an
.B AE
call.
.
By default,
.I ms
places the word \[lq]ABSTRACT\[rq] centered and in italics above the
text of the abstract.
.
The optional argument
.RB \[lq] no \[rq]
suppresses this heading.
.
.
.TP
.B .AE
End the abstract.
.
.
.\" ====================================================================
.SS "Text settings"
.\" ====================================================================
.
The
.B FAM
string,
a GNU extension,
sets the font family for body text;
the default is
.RB \[lq]\^ T \^\[rq].
.
The
.B PS
and
.B VS
registers set the type size and vertical spacing
(distance between text baselines),
respectively.
.
The font family and type size are ignored on terminals.
.
Set these parameters before the first call of a heading,
paragraphing,
or (non-date) document description macro to apply them to
headers,
footers,
and
(for
.BR FAM )
footnotes.
.
.
.br
.ne 2v
.P
The
.B HY
register defines the automatic hyphenation mode used with the
.B hy
request.
.
Setting
.B \[rs]n[HY]
.RB to\~ 0
disables automatic hyphenation.
.
This is a Research Tenth Edition Unix extension.
.
.
.\" ====================================================================
.SS "Typographical symbols"
.\" ====================================================================
.
.I ms
provides a few strings to obtain typographical symbols not easily
entered with the keyboard.
.
These and many others are available as special character escape
sequences\[em]see
.MR groff_char @MAN7EXT@ .
.
.
.TP
.B \[rs]*[\-]
Interpolate an em dash.
.
.
.TP
.B \[rs]*[Q]
.TQ
.B \[rs]*[U]
Interpolate typographer's quotation marks where available,
and neutral double quotes otherwise.
.
.B \[rs]*[Q]
is the left quote and
.B \[rs]*[U]
the right.
.
.
.\" ====================================================================
.SS Paragraphs
.\" ====================================================================
.
Paragraphing macros
.IR break ,
or terminate,
any pending output line so that a new paragraph can begin.
.
Several paragraph types are available,
differing in how indentation
applies to them:
to left,
right,
or both margins;
to the first output line of the paragraph,
all output lines,
or all but the first.
.
These calls insert vertical space in the amount stored in the
.B PD
register,
except at page or column breaks,
or adjacent to displays.
.
.
.PP
The
.B PORPHANS
register defines the minimum number of initial lines of any paragraph
that must be kept together to avoid isolated lines at the bottom of a
page.
.
If a new paragraph starts close to the bottom of a page,
and there is insufficient space to accommodate
.B \[rs]n[PORPHANS]
lines before an automatic page break,
.I "groff ms"
forces a page break before formatting the paragraph.
.
This is a GNU extension.
.
.
.TP
.B .LP
Set a paragraph without any (additional) indentation.
.
.
.TP
.B .PP
Set a paragraph with a first-line left indentation in the amount stored
in the
.B PI
register.
.
.
.TP
.BR .IP \~[\c
.IR mark \~[ width ]]
Set a paragraph with a left indentation.
.
The optional
.I mark
is not indented,
is useful in the construction of lists,
and is empty by default.
.
.I width
overrides the indentation amount in
.BR \[rs]n[PI] ;
its default unit is
.RB \[lq] n \[rq].
.
Once specified,
.I width
applies to further
.B IP
calls until specified again or a heading or different paragraphing macro
is called.
.
.
.TP
.B .QP
Set a paragraph indented from both left and right margins by
.BR \[rs]n[QI] .
.
.
.TP
.B .QS
.TQ
.B .QE
Begin
.RB ( QS )
and end
.RB ( QE )
a region where each paragraph is indented from both margins by
.BR \[rs]n[QI] .
.
The text between
.B QS
and
.B QE
can be structured further by use of other paragraphing macros.
.
.
.TP
.B .XP
Set an \[lq]exdented\[rq] paragraph\[em]one with a left indentation of
.B \[rs]n[PI]
on every line
.I except
the first
(also known as a hanging indent).
.
This is a Berkeley extension.
.
.
.\" ====================================================================
.SS Headings
.\" ====================================================================
.
Use headings to create a hierarchical structure for your document.
.
The
.I ms
macros print headings in
.B bold
using the same font family and,
by default,
type size as the body text.
.
Headings are available with and without automatic numbering.
.
Text on input lines following the macro call becomes the heading's
title.
.
Call a paragraphing macro to end the heading text and start the
section's content.
.
.
.TP
.BR .NH \~[\c
.IR depth ]
Set an automatically numbered heading.
.
.I ms
produces a numbered heading in the form
.IR a . b . c .\|.\|.,
to any level desired,
with the numbering of each depth increasing automatically and being
reset to zero when a more significant depth is increased.
.
.RB \[lq] 1 \[rq]\~is
the most significant or coarsest division of the document.
.
Only non-zero values are output.
.
If
.I depth
is omitted,
.I ms
assumes
.RB \[lq] 1 \[rq].
.
If you specify
.I depth
such that an ascending gap occurs relative to the previous
.B NH
call\[em]that is,
you \[lq]skip a depth\[rq],
as by
.RB \[lq] ".NH\~1" \[rq]
and then
.RB \[lq] ".NH\~3" \[rq],
.I groff ms
emits a warning on the standard error stream.
.
.
.TP
.BI ".NH S\~" heading-depth-index\~\c
\&.\|.\|.
Alternatively,
you can give
.B NH
a first argument
.RB of\~\[lq] S \[rq],
followed by integers to number the heading depths explicitly.
.
Further automatic numbering,
if used,
resumes using the specified indices as their predecessors.
.
.\" Although undocumented in Tuthill's 4.2BSD ms.diffs paper...
This feature is a Berkeley extension.
.
.
.br
.ne 3v
.P
After
.B NH
is called,
the assigned number is made available in the strings
.B SN\-DOT
(as it appears in a printed heading with default formatting,
followed by a terminating period)
and
.B SN\-NO\-DOT
(with the terminating period omitted).
.
These,
and
.BR SN\-STYLE ,
are GNU extensions.
.
.
.P
You can control the style used to print numbered headings by defining an
appropriate alias for the string
.BR SN\-STYLE .
.
By default,
.B \[rs]*[SN\-STYLE]
is aliased to
.BR \[rs]*[SN\-DOT] .
.
If you prefer to omit the terminating period from numbers appearing in
numbered headings,
you may alias it to
.BR \[rs]*[SN\-NO\-DOT] .
.
Any such change in numbering style becomes effective from the next use
of
.B NH
following redefinition of the alias for
.BR \[rs]*[SN\-STYLE] .
.
The formatted number of the current heading is available in
.B \[rs]*[SN]
(a feature first documented by Berkeley);
this string facilitates its inclusion in,
for example,
table captions,
equation labels,
and
.BR XS / XA / XE
table of contents entries.
.
.
.TP
.BR .SH \~[\c
.IR depth ]
Set an unnumbered heading.
.
The optional
.I depth
argument is a GNU extension indicating the heading depth corresponding
to the
.I depth
argument of
.BR NH .
.
It matches the type size at which the heading is set to that of a
numbered heading at the same depth when the
.B \[rs]n[GROWPS]
and
.B \[rs]n[PSINCR]
heading size adjustment mechanism is in effect.
.
.
.P
The
.B PSINCR
register defines an increment in type size to be applied to a heading at
a lesser depth than that specified in
.BR \[rs]n[GROWPS] .
.
The value of
.B \[rs]n[PSINCR]
should be specified in points with the
.RB \[lq] p \[rq]
scaling unit and may include a fractional component.
.
.
.P
The
.B GROWPS
register defines the heading depth above which the type size increment
set by
.B \[rs]n[PSINCR]
becomes effective.
.
For each heading depth less than the value of
.BR \[rs]n[GROWPS] ,
the type size is increased by
.BR \[rs]n[PSINCR] .
.
Setting
.B \[rs]n[GROWPS]
to a value less than\~2 disables the incremental heading size feature.
.
.
.P
In other words,
if the value of
.B GROWPS
register is greater than the
.I depth
argument to a
.B NH
or
.B SH
call,
the type size of a heading produced by these macros increases by
.B \[rs]n[PSINCR]
units over
.B \[rs]n[PS]
multiplied by the difference of
.B \[rs]n[GROWPS]
and
.IR depth .
.
.B GROWPS
and
.B PSINCR
are GNU extensions.
.
.
.P
In
.I "groff ms,"
the
.B NH
and
.B SH
macros consult the
.B HORPHANS
register to prevent the output of isolated headings at the bottom of a
page;
it specifies the minimum number of lines of the subsequent paragraph
that must be kept on the same page as the heading.
.
If insufficient space remains on the current page to accommodate the
heading and this number of lines of paragraph text,
.I "groff ms"
forces a page break before setting the heading.
.
Any display macro call or
.IR tbl ,
.IR pic ,
or
.I eqn
region between the heading and the subsequent paragraph suppresses this
grouping.
.
This is a GNU extension.
.
.
.\" ====================================================================
.SS "Typeface and decoration"
.\" ====================================================================
.
.
.P
The
.I ms
macros provide a variety of ways to style text.
.
Attend closely to the ordering of arguments labeled
.I pre
and
.I post,
which is not intuitive.
.
Support for
.I pre
arguments is a GNU extension.
.
.
.TP
.BR .B \~[\c
.IR text \~[ post \~[ pre ]]]
Style
.I text
in bold,
followed by
.I post
in the previous font style without intervening space,
and preceded by
.I pre
similarly.
.
Without arguments,
.I ms
styles subsequent text in bold
until the next
paragraphing,
heading,
or no-argument typeface macro call.
.
.
.TP
.BR .R \~[\c
.IR text \~[ post \~[ pre ]]]
As
.BR B ,
but use the roman style
(upright text of normal weight)
instead of bold.
.
Argument recognition is a GNU extension.
.
.
.TP
.BR .I \~[\c
.IR text \~[ post \~[ pre ]]]
As
.BR B ,
but use an italic or oblique style instead of bold.
.
.
.TP
.BR .BI \~[\c
.IR text \~[ post \~[ pre ]]]
As
.BR B ,
but use a bold italic or bold oblique style instead of upright bold.
.
This is a Research Tenth Edition Unix extension.
.\" possibly 9th, but definitely not Berkeley
.
.
.TP
.BR .CW \~[\c
.IR text \~[ post \~[ pre ]]]
As
.BR B ,
but use a constant-width (monospaced) roman typeface instead of bold.
.
This is a Research Tenth Edition Unix extension.
.\" possibly 9th, but definitely not Berkeley
.
.
.TP
.BR .BX \~[\c
.IR text ]
Typeset
.I text
and draw a box around it.
.
On terminals,
reverse video is used instead.
.
If you want
.I text
to contain space,
use unbreakable space or horizontal motion escape sequences
.RB ( \[rs]\[ti] ,
.BI \[rs] space\c
,
.BR \[rs]\[ha] ,
.BR \[rs]| ,
.BR \[rs]0 ,
or
.BR \[rs]h ).
.
.
.TP
.BR .UL \~[\c
.IR text \~[ post ]]
Typeset
.I text
with an underline.
.
On terminals,
.I text
is bracketed with underscores (\[lq]_\[rq]).
.
.I post,
if present,
is set after
.I text
with no intervening space.
.
.
.TP
.B .LG
Set subsequent text in larger type
(2\~points larger than the current size)
until the next
type size,
paragraphing,
or heading macro call.
.
Call the macro multiple times to enlarge the type size further.
.
.
.TP
.B .SM
Set subsequent text in smaller type
(2\~points smaller than the current size)
until the next
type size,
paragraphing,
or heading macro call.
.
Call the macro multiple times to reduce the type size further.
.
.
.TP
.B .NL
Set subsequent text at the normal type size
.RB ( \[rs]n[PS] ).
.
.
.P
When
.I pre
is used,
a hyphenation control escape sequence
.B \[rs]%
that would ordinarily start
.I text
must start
.I pre
instead.
.
.
.P
.I groff ms
also offers strings to begin and end super- and subscripting.
.
These are GNU extensions.
.
.
.TP
.B \[rs]*{
.TQ
.B \[rs]*}
Begin and end superscripting,
respectively.
.
.
.TP
.B \[rs]*<
.TQ
.B \[rs]*>
Begin and end subscripting,
respectively.
.
.
.\" ====================================================================
.SS "Indented regions"
.\" ====================================================================
.
You can indent a region of text while otherwise formatting it normally.
.
Such indented regions can be nested.
.
.
.TP
.B .RS
Begin a region where headings,
paragraphs,
and displays are indented (further) by
.BR \[rs]n[PI] .
.
.
.TP
.B .RE
End the (next) most recent indented region.
.
.
.\" ====================================================================
.SS "Keeps, boxed keeps, and displays"
.\" ====================================================================
.
On occasion,
you may want to
.I keep
several lines of text,
or a region of a document,
together on a single page,
preventing an automatic page break within certain boundaries.
.
This can cause a page break to occur earlier than it normally would.
.
.
.P
You can alternatively specify a
.I floating keep:
if a keep cannot fit on the current page,
.I ms
holds it,
allowing text following the keep
(in the source document)
to fill in the remainder of the current page.
.
When the page breaks by reaching its bottom or by
.B bp
request,
.I ms
puts the floating keep at the beginning of the next page.
.
.
.TP
.B .KS
Begin a keep.
.
.
.TP
.B .KF
Begin a floating keep.
.
.
.TP
.B .KE
End (floating) keep.
.
.
.P
As an alternative to the keep mechanism,
the
.B ne
request forces a page break if there is not at least the amount of
vertical space specified in its argument remaining on the page.
.
.
.br
.ne 5v
.PP
A
.I boxed keep
has a frame drawn around it.
.
.
.TP
.B .B1
Begin a keep with a box drawn around it.
.
.
.TP
.B .B2
End boxed keep.
.
.
.P
Boxed keep macros cause breaks;
to box words within a line,
recall
.B BX
in section \[lq]Highlighting\[rq] above.
.
.I ms
draws box lines close to the text they enclose
so that they are usable within paragraphs.
.
When boxing entire paragraphs thus,
you may improve their appearance by calling
.B B1
after the first paragraphing macro,
and invoking the
.B sp
request before calling
.BR B2 .
.
.
.P
If you want a boxed keep to float,
enclose the
.B B1
and
.B B2
calls within a pair of
.B KF
and
.B KE
calls.
.
.
.br
.ne 2v
.P
.I Displays
turn off filling;
lines of verse or program code are shown with their lines broken as in
the source document without requiring
.B br
requests between lines.
.
Displays can be kept on a single page or allowed to break across pages.
.
The
.B DS
macro begins a kept display of the layout specified in its first
argument;
non-kept displays are begun with dedicated macros corresponding to their
layout.
.
.
.TP
.B .DS L
.TQ
.B .LD
Begin
.RB ( DS ": kept)"
left-aligned display.
.
.
.TP
.BR .DS \~\c
.RB [ I \~\c
.RI [ indent ]]
.TQ
.BR .ID \~\c
.RI [ indent ]
Begin
.RB ( DS ": kept)"
display indented by
.I indent
if specified,
.B \[rs]n[DI]
otherwise.
.
.
.TP
.B .DS B
.TQ
.B .BD
Begin
.RB ( DS ": kept)"
block display:
the entire display is left-aligned,
but indented such that the longest line in the display is centered on
the page.
.
.
.TP
.B .DS C
.TQ
.B .CD
Begin
.RB ( DS ": kept)"
centered display:
each line in the display is centered.
.
.
.TP
.B .DS R
.TQ
.B .RD
Begin
.RB ( DS ": kept)"
right-aligned display.
.
This is a GNU extension.
.
.
.TP
.B .DE
End any display.
.
.
.P
.I "groff ms"
inserts the distance stored in
.B \[rs]n[DD]
before and after each pair of display macros;
this is a Berkeley extension.
.
This distance replaces any adjacent inter-paragraph distance
or subsequent spacing prior to a section heading.
.
The
.B DI
register is a GNU extension;
its value is an indentation applied to displays created with
.B DS
and
.B ID
without arguments,
to
.RB \[lq] .DS\~I \[rq]
without an indentation argument,
and to equations set with
.RB \[lq] .EQ\~I \[rq].
.
Changes to either register take effect at the next display boundary.
.
.
.\" ====================================================================
.SS "Tables, figures, equations, and references"
.\" ====================================================================
.
.I ms
often sees use with the
.IR @g@tbl ,
.IR @g@pic ,
.IR @g@eqn ,
and
.I @g@refer
preprocessors.
.
.I "groff ms"
applies the
.B \[rs]n[DD]
distance to regions of the document preprocessed with
.IR @g@eqn ,
.IR @g@pic ,
and
.IR @g@tbl .
.
Mark text meant for preprocessors by enclosing it in pairs of tokens as
follows,
with nothing between the dot and the macro name.
.
Preprocessors match these tokens only at the start of an input line.
.
The formatter interprets them as macro calls.
.
.
.TP
.BR .TS " [" H "]
.TQ
.B .TE
Demarcate a table to be processed by the
.I tbl
preprocessor.
.
The optional
.BR H "\~argument"
instructs
.I ms
to repeat table rows
(often column headings)
at the top of each new page the table spans,
if applicable;
calling the
.B TH
macro marks the end of such rows.
.
.MR @g@tbl @MAN1EXT@
provides a comprehensive reference to the preprocessor and offers
examples of its use.
.
.
.TP
.BI .PS\~ "h v"
.TQ
.B .PE
.TQ
.B .PF
.B PS
marks the start of a
.MR @g@pic @MAN1EXT@
preprocessor
diagram;
either of
.B PE
or
.B PF
ends it,
the latter with \[lq]flyback\[rq] to the vertical position at its top.
.
.I h
and
.I v
are the horizontal and vertical dimensions of the picture;
.I pic
supplies them automatically.
.
.
.TP
.BR .EQ \~[\c
.IR align \~[\c
.IR label ]]
.TQ
.B .EN
Demarcate mathematics to be processed by the
.I @g@eqn
preprocessor.
.
.I ms
centers the equation by default;
.I align
can be
.BR C ,
.BR L ,
.RB or\~ I
to (explicitly) center,
left-align,
or indent it by
.BR \[rs]n[DI] ,
respectively.
.
.I ms
right-aligns any
.IR label .
.
See
.MR @g@eqn @MAN1EXT@ .
.
.
.br
.ne 3v
.TP
.B .[
.TQ
.B .]
Demarcate a bibliographic citation to be processed by the
.I refer
preprocessor.
.
.MR @g@refer @MAN1EXT@
provides a comprehensive reference to the preprocessor and the format of
its bibliographic database.
.
.
.br
.ne 2v
.P
When
.I @g@refer
emits collected references
(as might be done on a \[lq]Works Cited\[rq] page),
it interpolates the string
.B \[rs]*[REFERENCES]
as an unnumbered heading
.RB ( .SH ).
.
.
.br
.ne 2v
.P
Attempting to place a multi-page table inside a keep can lead to
unpleasant results,
particularly if the
.I tbl \" generic
.RB \%\[lq] allbox \[rq]
option is used.
.
.
.\" ====================================================================
.SS Footnotes
.\" ====================================================================
.
A footnote is typically anchored to a place in the text with a
.I mark,
which is a small integer,
a symbol,
or arbitrary user-specified text.
.
.
.TP
.B \[rs]**
Place an
.I "automatic number,"
an automatically generated numeric footnote mark,
in the text.
.
Each time this string is interpolated,
the number it produces increments by one.
.
Automatic numbers start at 1.
.
This is a Berkeley extension.
.
.
.P
Enclose the footnote text in
.B FS
and
.B FE
macro calls to set it at the nearest available \[lq]foot\[rq],
or bottom,
of a text column or page.
.
.
.TP
.BR .FS \~[\c
.IR mark ]
Begin a footnote.
.
The
.B FS\-MARK
hook
(see below)
is called with any supplied
.I mark
argument,
which is then also placed at the beginning of the footnote text.
.
If
.I mark
is omitted,
the next pending automatic number enqueued by interpolation of the
.B *
string is used,
and if none exists,
nothing is prefixed.
.
.
.TP
.B .FE
End footnote text.
.
.
.P
.I groff ms
provides a hook macro,
.BR FS\-MARK ,
for user-determined operations to be performed when the
.B FS
macro is called.
.
It is passed the same arguments as
.B FS
itself.
.
By default,
this macro has an empty definition.
.
.B FS\-MARK
is a GNU extension.
.
.
.P
Footnote text is formatted as paragraphs are,
using analogous parameters.
.
The registers
.BR FI ,
.BR FPD ,
.BR FPS ,
and
.B FVS
correspond to
.BR PI ,
.BR PD ,
.BR PS ,
and
.BR VS ,
respectively;
.BR FPD ,
.BR FPS ,
and
.B FVS
are GNU extensions.
.
.
.P
The
.B FF
register controls the formatting of automatically numbered footnote
paragraphs,
and those for which
.B FS
is given a
.I mark
argument,
at the bottom of a column or page as follows.
.
.
.RS
.TP
0
Set an automatic number,
or a specified
.B FS
.I mark
argument,
as a superscript
(on typesetters)
or surrounded by square brackets
(on terminals).
.
The footnote paragraph is indented as with
.B PP
if there is an
.B FS
argument or an automatic number,
and as with
.B LP
otherwise.
.
This is the default.
.
.
.TP
1
As
.BR 0 ,
but set
.I mark
as regular text,
and follow an automatic number with a period.
.
.
.TP
2
As
.BR 1 ,
but without indentation
(like
.BR LP ).
.
.
.TP
3
As
.BR 1 ,
but set the footnote paragraph with
.I mark
hanging
(like
.BR IP ).
.RE
.
.
.\" ====================================================================
.SS "Language and localization"
.\" ====================================================================
.
.I groff ms
provides several strings that you can customize for your own purposes,
or redefine to adapt the macro package to languages other than English.
.
It is already localized for
.\" cs, de, es, fr, it, pl, ru, sv
Czech,
German,
Spanish,
French,
Italian,
Polish,
Russian,
and
Swedish.
.
Load the desired localization macro package after
.IR ms ;
see
.MR groff_tmac @MAN5EXT@ .
.
.
.P
.RS
.TS
cb   cb
lf(CR) lf(CR).
String	Default
_
\[rs]*[REFERENCES]	References
\[rs]*[ABSTRACT]	\[rs]f[I]ABSTRACT\[rs]f[]
\[rs]*[TOC]	Table of Contents
\[rs]*[MONTH1]	January
\[rs]*[MONTH2]	February
\[rs]*[MONTH3]	March
\[rs]*[MONTH4]	April
\[rs]*[MONTH5]	May
\[rs]*[MONTH6]	June
\[rs]*[MONTH7]	July
\[rs]*[MONTH8]	August
\[rs]*[MONTH9]	September
\[rs]*[MONTH10]	October
\[rs]*[MONTH11]	November
\[rs]*[MONTH12]	December
_
.TE
.RE
.
The default for
.B ABSTRACT
includes font selection escape sequences to set the word in italics.
.
.
.\" ====================================================================
.SS "Headers and footers"
.\" ====================================================================
.
There are multiple ways to produce headers and footers.
.
One is to define the strings
.BR LH ,
.BR CH ,
and
.B RH
to set the left,
center,
and right headers,
respectively;
and
.BR LF ,
.BR CF ,
and
.B RF
to set the left,
center,
and right footers.
.
This approach suffices for documents that do not distinguish odd- and
even-numbered pages.
.
.
.P
Another method is to call macros that set headers or footers for odd- or
even-numbered pages.
.
Each such macro takes a delimited argument separating the left,
center,
and right header or footer texts from each other.
.
You can replace the neutral apostrophes (\[aq]) shown below with any
character not appearing in the header or footer text.
.
These macros are Berkeley extensions.
.
.
.br
.ne 5v
.TP
.BR .OH \~\[aq]\c
.IR left \[aq] center \[aq] right \[aq]
.TQ
.BR .OF \~\[aq]\c
.IR left \[aq] center \[aq] right \[aq]
.TQ
.BR .EH \~\[aq]\c
.IR left \[aq] center \[aq] right \[aq]
.TQ
.BR .EF \~\[aq]\c
.IR left \[aq] center \[aq] right \[aq]
The
.B OH
and
.B EH
macros define headers for odd- (recto) and even-numbered (verso) pages,
respectively;
the
.B OF
and
.B EF
macros define footers for them.
.
.
.P
With either method,
a percent sign
.B %
in header or footer text is replaced by the current page number.
.
By default,
.I ms
places no header on a page numbered \[lq]1\[rq]
(regardless of its number format).
.
.
.TP
.B .P1
Typeset the header even on page\~1.
.
To be effective,
this macro must be called before the header trap is sprung on any page
numbered \[lq]1\[rq].
.
This is a Berkeley extension.
.
.
.P
For even greater flexibility,
.I ms
is designed to permit the redefinition of the macros that are called
when formatter traps
that ordinarily cause the headers and footers to be output are sprung.
.
.B PT
(\[lq]page trap\[rq])
is called by
.I ms
when the header is to be written,
and
.B BT
(\[lq]bottom trap\[rq])
when the footer is to be.
.
The
.I groff
page location trap that
.I ms
sets up to format the header also calls the
(normally undefined)
.B HD
macro after
.BR PT ;
you can define
.B HD
if you need additional processing after setting the header.
.
.\" Although undocumented in Tuthill's 4.2BSD ms.diffs paper...
The
.B HD
hook is a Berkeley extension.
.
Any such macros you (re)define must implement any desired specialization
for odd-,
even-,
or first numbered pages.
.
.
.\" ====================================================================
.SS "Tab stops"
.\" ====================================================================
.
Use the
.B ta
request to set tab stops as needed.
.
.
.TP
.B .TA
Reset the tab stops to the
.I ms
default
(every 5 ens).
.
Redefine this macro to create a different set of default tab stops.
.
.
.\" ====================================================================
.SS Margins
.\" ====================================================================
.
Control margins using the registers summarized in the \[lq]Margins\[rq]
portion of the table in section \[lq]Document control settings\[rq]
above.
.
There is no setting for the right margin;
the combination of page offset
.B \[rs]n[PO]
and line length
.B \[rs]n[LL]
determines it.
.
.
.\" ====================================================================
.SS "Multiple columns"
.\" ====================================================================
.
.I ms
can set text in as many columns as reasonably fit on the page.
.
The following macros force a page break if a multi-column layout is
active when they are called.
.
.B \[rs]n[MINGW]
is the default minimum gutter width;
it is a GNU extension.
.
When multiple columns are in use,
keeps
and the
.B \%HORPHANS
and
.B \%PORPHANS
registers
work with respect to column breaks instead of page breaks.
.
.
.TP
.B .1C
Arrange page text in a single column
(the default).
.
.
.TP
.B .2C
Arrange page text in two columns.
.
.
.TP
.BR .MC \~[\c
.IR column-width " [" gutter-width ]]
Arrange page text in multiple columns.
.
If you specify no arguments,
it is equivalent to the
.B 2C
macro.
.
Otherwise,
.I column-width
is the width of each column and
.I gutter-width
is the minimum distance between columns.
.
.
.\" ====================================================================
.SS "Creating a table of contents"
.\" ====================================================================
.
Define an entry to appear in the table of contents by bracketing its
text between calls to the
.B XS
and
.B XE
macros.
.
A typical application is to call them immediately after
.B NH
or
.B SH
and repeat the heading text within them.
.
The
.B XA
macro,
used within
.BR XS / XE
pairs,
supplements an entry\[em]for instance,
when it requires multiple output lines,
whether because a heading is too long to fit or because style dictates
that page numbers not be repeated.
.
You may wish to indent the text thus wrapped to correspond to its
heading depth;
this can be done in the entry text by prefixing it with tabs or
horizontal motion escape sequences,
or by providing a second argument to the
.B XA
macro.
.
.B XS
and
.B XA
automatically associate the page number where they are called with the
text following them,
but they accept arguments to override this behavior.
.
At the end of the document,
call
.B TC
or
.B PX
to emit the table of contents;
.B TC
resets the page number
.RB to\~ i
(Roman numeral one),
and then calls
.BR PX .
.
All of these macros are Berkeley extensions.
.
.
.TP
.BR .XS \~[\c
.IR page-number ]
.TQ
.BR .XA \~[\c
.IR page-number \~[ indentation ]]
.TQ
.B .XE
Begin,
supplement,
and end a table of contents entry.
.
Each entry is associated with
.I page-number
(otherwise the current page number);
a
.I page-number
of
.RB \[lq] no \[rq]
prevents a leader and page number from being emitted for that entry.
.
Use of
.B XA
within
.BR XS / XE
is optional;
it can be repeated.
.
If
.I indentation
is present,
a supplemental entry is indented by that amount;
ens are assumed if no unit is indicated.
.
Text on input lines between
.B XS
and
.B XE
is stored for later recall by
.BR PX .
.
.
.TP
.BR .PX \~[ no ]
Switch to single-column layout.
.
Unless
.RB \[lq] no \[rq]
is specified,
center and interpolate
.B \[rs]*[TOC]
in bold and two points larger than the body text.
.
Emit the table of contents entries.
.
.
.TP
.BR .TC \~[ no ]
Set the page number to\~1,
the page number format to lowercase Roman numerals,
and call
.B PX
(with a
.RB \[lq] no \[rq]
argument,
if present).
.
.
.P
The remaining features in this subsection are GNU extensions.
.
.I groff ms
obviates the need to repeat heading text after
.B XS
calls.
.
Call
.B XN
and
.B XH
after
.B NH
and
.BR SH ,
respectively.
.
Text to be appended to the formatted section heading,
but not to appear in the table of contents entry,
can follow these calls.
.
.
.TP
.BI .XN\~ heading-text
Format
.I heading-text
and create a corresponding table of contents entry;
the indentation is computed from the
.I depth
argument of the preceding
.B NH
call.
.
.
.TP
.BI .XH\~ "depth heading-text"
As
.BR XN ,
but use
.I depth
to determine the indentation.
.
.
.P
.I groff ms
encourages customization of table of contents entry production.
.
(Re-)define any of the following macros as desired.
.
.
.TP
.BI \%.XN\-REPLACEMENT\~ heading-text
.TQ
.BI \%.XH\-REPLACEMENT\~ "depth heading-text"
These hook macros implement
.B XN
and
.BR XH ,
and call
.B \%XN\-INIT
and
.BR \%XH\-INIT ,
respectively,
then call
.B \%XH\-UPDATE\-TOC
with the arguments given them.
.
.
.TP
.B \%.XH\-INIT
.TQ
.B \%.XN\-INIT
These hook macros do nothing by default.
.
.
.TP
.BI \%.XH\-UPDATE\-TOC\~ "depth heading-text"
Bracket
.I heading-text
with
.B XS
and
.B XE
calls,
indenting it by 2 ens per level of
.I depth
beyond the first.
.
.
.P
You can customize the style of the leader that bridges each table of
contents entry with its page number;
define the
.B TC\-LEADER
special character by using the
.B char
request.
.
A typical leader combines the dot glyph
.RB \[lq] .\& \[rq]
with a horizontal motion escape sequence to spread the dots.
.
The width of the page number field is stored in the
.B TC\-MARGIN
register.
.
.
.\" ====================================================================
.SH "Differences from AT&T \f[I]ms\f[]"
.\" ====================================================================
.
The
.I groff ms
macros are an independent reimplementation,
using no AT&T code.
.
Since they take advantage of the extended features of
.IR groff ,
they cannot be used with AT&T
.IR troff .
.
.I groff ms
supports features described above as Berkeley and
Research Tenth Edition Unix extensions,
and adds several of its own.
.
.
.IP \[bu] 3n
The internals of
.I groff ms
differ from those of
AT&T
.IR ms .
.
Documents that depend upon implementation details of
AT&T
.I ms
may not format properly with
.IR "groff ms" .
.
Such details include macros whose function was not documented in the
AT&T
.I ms
manual
(\[lq]Typing Documents on the UNIX System: Using the \-ms Macros with
Troff and Nroff\[rq],
M.\& E.\& Lesk,
Bell Laboratories,
1978).
.\" TODO: Use refer(1)?
.\" XXX: We support RT anyway; maybe we should stop?
.
.
.IP \[bu]
The error-handling policy of
.I groff ms
is to detect and report errors,
rather than to ignore them silently.
.
.
.IP \[bu]
Research Tenth Edition \" possibly 9th
Unix supported
.BR P1 / P2
macros to bracket code examples;
.I groff ms
does not.
.
.
.IP \[bu]
.I groff ms
does not work in GNU
.IR troff 's \" GNU
AT&T compatibility mode.
.
If loaded when that mode is enabled,
it aborts processing with a diagnostic message.
.
.
.IP \[bu]
Multiple line spacing is not supported.
.
Use a larger vertical spacing instead.
.
.
.IP \[bu]
.I groff ms
uses the same header and footer defaults in both
.I nroff
and
.I troff
modes
as AT&T
.I ms
does in
.I troff
mode;
AT&T's default in
.I nroff
mode is to put the date,
in U.S.\& traditional format
(e.g.,
\[lq]January 1, 2021\[rq]),
in the center footer
(the
.B CF
string).
.
.
.IP \[bu]
Many
.I groff ms
macros,
including those for paragraphs,
headings,
and displays,
cause a reset of paragraph rendering parameters,
and may change the indentation;
they do so not by incrementing or decrementing it,
but by setting it absolutely.
.
This can cause problems for documents that define additional macros of
their own that manipulate indentation.
.
Use
.B RS
and
.B RE
instead of the
.B in
request.
.
.
.IP \[bu]
AT&T
.I ms
interpreted the values of the registers
.B PS
and
.B VS
in points,
and did not support the use of scaling units with them.
.
.I groff ms
interprets values of the registers
.BR PS ,
.BR VS ,
.BR FPS ,
and
.BR FVS ,
equal to or larger than\~1,000
(one thousand)
as decimal fractions multiplied by\~1,000.
.
(Register values are converted to and stored as basic
units.
.
See \[lq]Measurements\[rq] in the
.I groff
Texinfo manual or in
.MR groff @MAN7EXT@ ).
.
This threshold makes use of a scaling unit with these parameters
practical for high-resolution devices while preserving backward
compatibility.
.
It also permits expression of non-integral type sizes.
.
For example,
.RB \[lq] "groff \-rPS=10.5p" \[rq]
at the shell prompt is equivalent to placing
.RB \[lq] ".nr PS 10.5p" \[rq]
at the beginning of the document.
.\" Note to document maintainers:
.\"
.\" We use the integral point scaling unit `p` instead of the
.\" typographical point `z` because this is a register assignment; the
.\" value gets converted to scaled points automatically.
.\" Observe:
.\"    $ printf '.nr PS 10.5p\n.pnr PS\n' | groff # 1.24 or later
.\"    PS      10500   +0      0
.\"
.\" groff ms users can thus remain innocent of the z unit if they like.
.
.
.IP \[bu]
AT&T
.IR ms 's
.B AU
macro supported arguments
whose values were used with some
.RB non- RP
document types;
that of
.I "groff ms"
does not.
.
.
.IP \[bu]
Right-aligned displays are available.
.
The AT&T
.I ms
manual observes that \[lq]it is tempting to assume that
.RB \[lq] ".DS R" \[rq]
will right adjust lines,
but it doesn't work\[rq].
.
In
.IR "groff ms" ,
it does.
.
.
.IP \[bu]
To make
.I groff ms
use the default page offset
(which also specifies the left margin),
the
.B PO
register must stay undefined until the first
.I ms
macro is called.
.
This implies that
.B \[rs]n[PO]
should not be used early in the document,
unless it is changed also:
accessing an undefined register automatically defines it.
.
.
.IP \[bu]
.I groff ms
supports the
.B PN
register,
but it is not necessary;
you can access the page number via the usual
.B %
register and invoke the
.B af
request to assign a different format to it if desired.
.
(If you redefine the
.I ms
.B PT
macro \" I wouldn't mention that, but Lesk 1978 encourages doing so. :-/
and desire special treatment of certain page numbers\[em]like
.RB \[lq] 1 \[rq]\[em]you
may need to handle a non-Arabic page number format,
as
.IR "groff ms" 's
.B PT
does;
see the macro package source.
.
.I groff ms
aliases the
.B PN
register to
.BR % .)
.
.
.IP \[bu]
The AT&T
.I ms
manual documents registers
.B CW
and
.B GW
as setting the default column width and \[lq]intercolumn gap\[rq],
respectively,
and which applied when
.B MC
was called with fewer than two arguments.
.
.I groff ms
instead treats
.B MC
without arguments as synonymous with
.BR 2C ;
there is thus no occasion for a default column width register.
.
Further,
the
.B MINGW
register
and the second argument to
.B MC
specify a
.I minimum
space between columns,
not the fixed gutter width of AT&T
.IR ms .
.
.
.IP \[bu]
The AT&T
.I ms
manual did not document the
.B QI
register;
Berkeley and
.I "groff ms"
do.
.
.
.IP \[bu]
.I "groff ms"
sets the register
.B GS
to\~1;
the AT&T
.I ms
package does not use it.
.
A document can test its value to determine whether it is being formatted
with
.I "groff ms"
or another implementation.
.
.
.\" ====================================================================
.SS "Unix Version\~7 macros unimplemented by \f[I]groff ms\f[]"
.\" ====================================================================
.
Several macros described in the Unix Version\~7
.I ms
documentation are unimplemented by
.I groff ms
because they are specific to the requirements of documents produced
internally by Bell Laboratories,
some of which also require a glyph for the Bell System logo that
.I groff
does not support.
.
These macros implemented several document type formats
(\c
.BR EG , \" engineer's notes
.BR IM , \" internal memorandum
.BR MF , \" memorandum for file
.BR MR , \" memorandum for record
.BR TM , \" technical memorandum
.BR TR ), \" technical report
were meaningful only in conjunction with the use of certain document
types
(\c
.BR AT , \" attachments
.BR CS , \" cover sheet info for `TM` documents
.BR CT , \" copies to
.BR OK , \" "other keywords" for `TM` documents
.BR SG ), \" signatures for `TM` documents
stored the postal addresses of Bell Labs sites
(\c
.BR HO , \" Holmdel
.BR IH , \" Naperville
.BR MH , \" Murray Hill
.BR PY , \" Piscataway
.BR WH ), \" Whippany
or lacked a stable definition over time
(\c
.BR UX ). \" Unix; on 1st use, add footnote identifying trademark owner
.
.
.\" ====================================================================
.SH "Legacy features"
.\" ====================================================================
.
.I "groff ms"
retains some legacy features solely to support formatting of historical
documents;
contemporary ones should not use them because they can render poorly.
.
See
.MR groff_char @MAN7EXT@
instead.
.
.
.\" ====================================================================
.SS "AT&T \f[I]ms\f[] accent mark strings"
.\" ====================================================================
.
AT&T
.I ms
defined
accent mark strings as follows.
.
.
.P
.TS
Cb Lb
Lf(CR) L.
String	Description
_
\[rs]*[\[aq]]	Apply acute accent to subsequent glyph.
\[rs]*[\[ga]]	Apply grave accent to subsequent glyph.
\[rs]*[:]	Apply dieresis (umlaut) to subsequent glyph.
\[rs]*[\[ha]]	Apply circumflex accent to subsequent glyph.
\[rs]*[\[ti]]	Apply tilde accent to subsequent glyph.
\[rs]*[C]	Apply caron to subsequent glyph.
.\" \*v was an undocumented (in Lesk 1978-11-13) synonym for \*C.
\[rs]*[,]	Apply cedilla to subsequent glyph.
.TE
.
.
.\" ====================================================================
.SS "Berkeley \f[I]ms\f[] accent mark and glyph strings"
.\" ====================================================================
.
Berkeley
.I ms
offered an
.B AM
macro;
calling it redefined the AT&T accent mark strings
(except for
.BR \[rs]*C ),
applied them to the
.I preceding
glyph,
and defined additional strings,
some for spacing glyphs.
.
.
.TP
.B .AM
Enable alternative accent mark and glyph-producing strings.
.
.
.P
.TS
Cb Lb
Lf(CR) L.
String	Description
_
\[rs]*[\[aq]]	Apply acute accent to preceding glyph.
\[rs]*[\[ga]]	Apply grave accent to preceding glyph.
\[rs]*[:]	Apply dieresis (umlaut) to preceding glyph.
\[rs]*[\[ha]]	Apply circumflex accent to preceding glyph.
\[rs]*[\[ti]]	Apply tilde accent to preceding glyph.
\[rs]*[,]	Apply cedilla to preceding glyph.
\[rs]*[/]	Apply stroke (slash) to preceding glyph.
\[rs]*[v]	Apply caron to preceding glyph.
\[rs]*[_]	Apply macron to preceding glyph.
\[rs]*[.]	Apply underdot to preceding glyph.
\[rs]*[o]	Apply ring accent to preceding glyph.
_
\[rs]*[?]	Interpolate inverted question mark.
\[rs]*[!]	Interpolate inverted exclamation mark.
\[rs]*[8]	Interpolate small letter sharp s.
\[rs]*[q]	Interpolate small letter o with hook accent (ogonek).
\[rs]*[3]	Interpolate small letter yogh.
\[rs]*[d\-]	Interpolate small letter eth.
\[rs]*[D\-]	Interpolate capital letter eth.
\[rs]*[th]	Interpolate small letter thorn.
\[rs]*[TH]	Interpolate capital letter thorn.
\[rs]*[ae]	Interpolate small ae ligature.
\[rs]*[AE]	Interpolate capital ae ligature.
\[rs]*[oe]	Interpolate small oe ligature.
\[rs]*[OE]	Interpolate capital oe ligature.
.TE
.
.
.\" ====================================================================
.SH "Naming conventions"
.\" ====================================================================
.
External names available to documents that use the
.I "groff ms"
macros contain only uppercase letters and digits.
.
The package reserves for internal use the following identifiers:
.
.
.IP \[bu] 3n
those containing the characters
.BR * ,
.BR @ ,
and\~\c
.BR : ;
and
.
.
.IP \[bu]
those containing only uppercase letters and digits.
.
.
.P
When selecting a name for your document's own macros,
strings,
and
registers,
avoid those reserved by
.I "groff ms"
and those defined by
GNU
.IR troff .\" GNU
See
.MR groff @MAN7EXT@
for complete lists thereof.
.
.
.P
.I "groff ms"
organizes most of its internal names into modules.
.
The naming convenion is as follows.
.
.
.IP \[bu] 3n
Names used only within one module are of the form
.IB \%module * name\c
\&.
.
.
.IP \[bu]
Names used outside the module in which they are defined are of the form
.IB \%module @ name\c
\&.
.
.
.IP \[bu]
Names associated with a particular environment are of the form
.IB \%environment : name\c
\&;
these are used only within the
.B par
module.
.
.
.IP \[bu]
.I name
does not have a module prefix.
.
.
.IP \[bu]
Names constructed to implement arrays are of the form
.IB \%array ! index\c
\&.
.
.
.\" ====================================================================
.SH Files
.\" ====================================================================
.
.TP
.I @MACRODIR@/\:@TMAC_S_PREFIX@s\:.tmac
implements the package.
.
.
.TP
.I @MACRODIR@/refer\-ms.tmac
implements
.MR @g@refer @MAN1EXT@
support for
.IR ms .
.
.
.TP
.I @MACRODIR@/\:ms\:.tmac
is a wrapper enabling the package to be loaded with the option
.RB \[lq] "\-m ms" \[rq].
.
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
The GNU version of the
.I ms
macro package was written by James Clark and contributors.
.
This document was written by Clark,
.MT lkollar@\:despammed\:.com
Larry Kollar
.ME ,
and
.MT g.branden\:.robinson@\:gmail\:.com
G.\& Branden Robinson
.ME .
.
.
.br
.ne 8v
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
A manual is available in source and rendered form.
.
On your system,
it may be compressed and/or available in additional formats.
.
.
.TP
.I @DOCDIR@/\:ms\:.ms
.TQ
.I @DOCDIR@/\:ms\:.ps
\[lq]Using
.I groff
with the
.I ms
Macro Package\[rq];
Larry Kollar and \%G.\~Branden Robinson.
.
.
.br
.ne 5v
.TP
.I @DOCDIR@/\:\%msboxes\:.ms
.TQ
.I @DOCDIR@/\:\%msboxes\:.pdf
\[lq]Using PDF boxes with
.I groff
and the
.I ms
macros\[rq];
Deri James.
.
.B \%BOXSTART
and
.B \%BOXSTOP
macros are available via the
.I sboxes
extension package,
enabling colored,
bordered boxes when the
.B pdf
output device is used.
.
.
.PP
.IR "Groff: The GNU Implementation of troff" ,
by Trent A.\& Fisher and Werner Lemberg,
is the primary
.I groff
manual.
.
You can browse it interactively with \[lq]info groff\[rq].
.
.
.PP
.MR groff @MAN1EXT@ ,
.MR @g@troff @MAN1EXT@ ,
.MR @g@tbl @MAN1EXT@ ,
.MR @g@pic @MAN1EXT@ ,
.MR @g@eqn @MAN1EXT@ ,
.MR @g@refer @MAN1EXT@
.
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_groff_ms_7_man_C]
.do rr *groff_groff_ms_7_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
