'\" t
.TH gpinyin @MAN1EXT@ "@MDATE@" "groff @VERSION@"
.SH Name
gpinyin \- use Hanyu Pinyin Chinese in
.I groff
documents
.
.
.\" ====================================================================
.\" Legal Terms
.\" ====================================================================
.\"
.\" Copyright 2014-2020 Free Software Foundation, Inc.
.\"
.\" This file is part of gpinyin.
.\"
.\" gpinyin is distributed with groff, the GNU roff typesetting system.
.\"
.\" groff is free software; you can redistribute it and/or modify it
.\" under the terms of the GNU General Public License as published by
.\" the Free Software Foundation, either version 3 of the License, or
.\" (at your option) any later version.
.\"
.\" groff is distributed in the hope that it will be useful, but WITHOUT
.\" ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
.\" or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
.\" License for more details.
.\"
.\" You should have received a copy of the GNU General Public License
.\" along with this program.  If not, see
.\" <https://www.gnu.org/licenses/>.
.
.
.\" Save and disable compatibility mode (for, e.g., Solaris 10/11).
.do nr *groff_gpinyin_1_man_C \n[.cp]
.cp 0
.
.\" Define fallback for groff 1.23's MR macro if the system lacks it.
.nr do-fallback 0
.if !\n(.f           .nr do-fallback 1 \" mandoc
.if  \n(.g .if !d MR .nr do-fallback 1 \" older groff
.if !\n(.g           .nr do-fallback 1 \" non-groff *roff
.if \n[do-fallback]  \{\
.  de MR
.    ie \\n(.$=1 \
.      I \%\\$1
.    el \
.      IR \%\\$1 (\\$2)\\$3
.  .
.\}
.rr do-fallback
.
.
.\" ====================================================================
.\" Local definitions
.\" ====================================================================
.
.\" Define a string for the TeX logo.
.ie t .ds TeX T\h'-.1667m'\v'.224m'E\v'-.224m'\h'-.125m'X
.el   .ds TeX TeX
.
.
.\" ====================================================================
.SH Synopsis
.\" ====================================================================
.
.SY gpinyin
.RI [ file\~ .\|.\|.]
.YS
.
.
.P
.SY gpinyin
.B \-h
.YS
.
.SY gpinyin
.B \-\-help
.YS
.
.
.P
.SY gpinyin
.B \-v
.YS
.
.SY gpinyin
.B \%\-\-version
.YS
.
.
.\" ====================================================================
.SH Description
.\" ====================================================================
.
.I gpinyin
is a preprocessor for
.MR groff @MAN1EXT@
that facilitates use of Hanyu Pinyin in
.MR groff @MAN7EXT@
files.
.
Pinyin is a method for writing the Mandarin Chinese language with the
Latin alphabet.
.
Mandarin consists of more than four hundred base syllables,
each spoken with one of five different tones.
.
Changing the tone applied to the syllable generally alters the meaning
of the word it forms.
.
In Pinyin,
a syllable is written in the Latin alphabet and a numeric tone indicator
can be appended to each syllable.
.
.
.P
Each
.I input-file
is a file name or the character
.RB \[lq] \- \[rq]
to indicate that the standard input stream should be read.
.
As usual,
the argument
.RB \[lq] \-\- \[rq]
can be used in order to force interpretation of all remaining arguments
as file names,
even if an
.I input-file
argument begins with a
.RB \[lq] \- \[rq].
.
.B \-h
and
.B \-\-help
display a usage message,
while
.B \-v
and
.B \%\-\-version
show version information;
all exit afterward.
.
.
.\" ====================================================================
.SS "Pinyin sections"
.\" ====================================================================
.
Pinyin sections in
.I groff
files are enclosed by two
.B .pinyin
requests with different arguments.
.
The starting request is
.RS
.EX
\&.pinyin start
.EE
.RE
or
.RS
.EX
\&.pinyin begin
.EE
.RE
and the ending request is
.RS
.EX
\&.pinyin stop
.EE
.RE
or
.RS
.EX
\&.pinyin end
.EE
.RE
\&.
.
.
.\" ====================================================================
.SS Syllables
.\" ====================================================================
.
In Pinyin,
each syllable is represented by one to six letters drawn from the
fifty-two upper- and lowercase letters of the Unicode basic Latin
character set,
plus the letter \[lq]U\[rq] with dieresis (umlaut) in both cases\[em]in
other words,
the members of the set \[lq][a\[en]zA\[en]Z\[:u]\[:U]]\[rq].
.
.
.P
In
.I groff
input,
all basic Latin letters are written as themselves.
.
The \[lq]u with dieresis\[rq] can be written as
\[lq]\e[:u]\[rq]
in lowercase or
\[lq]\e[:U]\[rq]
in uppercase.
.
Within
.B .pinyin
sections,
.I gpinyin
supports the form
\[lq]ue\[rq]
for lowercase and the forms
\[lq]Ue\[rq]
and
\[lq]UE\[rq]
for uppercase.
.
.
.\" ====================================================================
.SS Tones
.\" ====================================================================
.
Each syllable has exactly one of five
.IR tones .
.
The fifth tone is not explicitly written at all,
but each of the first through fourth tones is indicated with a diacritic
above a specific vowel within the syllable.
.
.
.P
In a
.I gpinyin
source file,
these tones are written by adding a numeral in the range 0 to 5 after
the syllable.
.
The tone numbers 1 to 4 are transformed into accents above vowels in the
output.
.
The tone numbers 0 and 5 are synonymous.
.
.
.P
.nr gpinyin*do-table 0
.if t .nr gpinyin*do-table 1
.if n .if '\*[.T]'utf8' .nr gpinyin*do-table 1
.\" XXX: One hack necessitates another; since our table is conditional,
.\" we need to save the input line counter.
.nr gpinyin*.c \n[.c]
.ie \n[gpinyin*do-table] \{\
The tones are written as follows.
.
.
.P
.\" XXX: This is so gross.  Why can't grops and gropdf figure this out?
.if t .ds a- \za\[a-]
.if n .ds a- \[a a-]
.if t .ds a< \za\[ah]
.if n .ds a< \[a ah]
.if t .ne 8 \" Try to keep the table on one page for printed output.
.TS
l l l l l.
Tone	Description	Diacritic	Example Input	Example Output
_
first	flat	\[a-]	ma1	m\*[a-]
second	rising	\[aa]	ma2	m\[a aa]
third	falling-rising	\[ah]	ma3	m\*[a<]
fourth	falling	\[ga]	ma4	m\[a ga]
fifth	neutral	(none)	ma0	ma
\^	\^	\^	ma5	\^
.TE
.\}
.lf (\n[gpinyin*.c] + 25) \" XXX part 2: Restore input line counter.
.el \{\
[The tone mark table is omitted from this rendering of the man page
because the selected output device \[lq]\*[.T]\[rq] lacks the character
repertoire to display it.
.
Try another output device.]
.\}
.rm a-
.rm a<
.rr gpinyin*do-table
.
.
.P
The neutral tone number can be omitted from a word-final syllable,
but not otherwise.
.
.
.\" ====================================================================
.SH Authors
.\" ====================================================================
.
.I gpinyin
was written by
.MT groff\-bernd\:.warken\-72@\:web\:.de
Bernd Warken
.ME .
.
.
.\" ====================================================================
.SH "See also"
.\" ====================================================================
.
Useful documents on the World Wide Web related to Pinyin include
.RS 4n
.UR http://\:www\:.foolsworkshop\:.com/\:ptou/\:index\:.html
.I Pinyin to Unicode
.UE ,
.
.br
.UR http://\:www\:.mandarintools\:.com/
.I On-line Chinese Tools \" sic: On-line
.UE ,
.
.br
.\" XXX: Turning off adjustment like this is ugly; thanks to meter-long
.\" URLs we need an escape sequence that selectively disables adjustment
.\" at the end of a word.
.na
.UR http://\:www\:.pinyin\:.info/\:index\:.html
.I Pinyin.info: a guide to the writing of Mandarin Chinese in \
romanization
.UE ,
.\" XXX: cringe
.ie d AD .ad \*[AD]
.el      .ad b
.
.br
.UR http://\:www\:.pinyin\:.info/\:rules/\:where.html
\[lq]Where do the tone marks go?\[rq]
.UE ,
.
.br
.UR http://\:git\:.savannah\:.gnu\:.org/\:gitweb/\:\
?p=cjk\:.git\:;a=blob_plain\:;f=doc/\:pinyin\:.txt\:;hb=HEAD
.I pinyin.txt
from the CJK macro package for \*[TeX]
.UE ,
.br
.RS -4n
and
.RE
.
.br
.\" XXX: Same ugliness as before.
.na
.UR http://\:git\:.savannah\:.gnu\:.org/\:gitweb/\:\
?p=cjk\:.git\:;a=blob_plain\:;f=texinput/\:pinyin\:.sty\:;hb=HEAD
.I pinyin.sty
from the CJK macro package for \*[TeX]
.UE .
.\" XXX: cringe
.ie d AD .ad \*[AD]
.el      .ad b
.
.RE
.
.
.P
.MR groff @MAN1EXT@
and
.MR grog @MAN1EXT@
explain how to view
.I roff
documents.
.
.
.P
.MR groff @MAN7EXT@
and
.MR groff_char @MAN7EXT@
are comprehensive references covering the language elements of GNU
.I troff \" GNU
and the available glyph repertoire,
respectively.
.
.
.\" Clean up.
.rm TeX
.
.\" Restore compatibility mode (for, e.g., Solaris 10/11).
.cp \n[*groff_gpinyin_1_man_C]
.do rr *groff_gpinyin_1_man_C
.
.
.\" Local Variables:
.\" fill-column: 72
.\" mode: nroff
.\" End:
.\" vim: set filetype=groff textwidth=72:
